<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Service;
use App\Models\Skill;
use App\Models\Experience;
use App\Models\Sector;
use App\Models\Project;
use Illuminate\Support\Str;

class ContentSeeder extends Seeder
{
    public function run()
    {
        // 1. Services
        $services = [
            [
                'title' => ['en' => 'Full-Stack Development', 'ar' => 'تطوير ويب متكامل'],
                'description' => ['en' => 'Building web applications using modern frameworks (Laravel, .NET Core, React, Angular) with clean, maintainable code.', 'ar' => 'بناء تطبيقات ويب باستخدام أطر عمل حديثة (Laravel، .NET Core، React، Angular) مع كود نظيف وقابل للتطوير.'],
                'icon' => 'fa-light fa-code'
            ],
            [
                'title' => ['en' => 'ERP & HRIS Solutions', 'ar' => 'حلول ERP و HRIS'],
                'description' => ['en' => 'Designing and implementing integrated systems for accounts, payroll, HR, inventory, and more, tailored to client needs.', 'ar' => 'تصميم وتنفيذ أنظمة متكاملة للمحاسبة والرواتب والموارد البشرية والمخازن، مصممة خصيصاً لاحتياجات العميل.'],
                'icon' => 'fa-light fa-database'
            ],
            [
                'title' => ['en' => 'Technical Leadership & Consulting', 'ar' => 'قيادة تقنية واستشارات'],
                'description' => ['en' => 'Leading agile teams, defining project scope, architecting solutions, and ensuring alignment with business goals.', 'ar' => 'قيادة فرق Agile، تحديد نطاق المشاريع، تصميم البنية التحتية، وضمان التوافق مع أهداف العمل.'],
                'icon' => 'fa-light fa-user-tie'
            ],
            [
                'title' => ['en' => 'System Integration & APIs', 'ar' => 'تكامل الأنظمة و APIs'],
                'description' => ['en' => 'Connecting disparate systems through robust APIs and microservices architecture.', 'ar' => 'ربط الأنظمة المختلفة عبر واجهات برمجة تطبيقات قوية وبنية microservices.'],
                'icon' => 'fa-light fa-link'
            ],
            [
                'title' => ['en' => 'Digital Marketing Strategy for Tech Products', 'ar' => 'استراتيجية تسويق رقمي للمنتجات التقنية'],
                'description' => ['en' => 'Applying market analysis, user-centric design, and conversion optimization to ensure your product reaches its audience effectively.', 'ar' => 'تطبيق تحليل السوق والتصميم المرتكز على المستخدم وتحسين معدل التحويل لضمان وصول منتجك إلى الجمهور المناسب.'],
                'icon' => 'fa-light fa-chart-line'
            ],
        ];

        foreach ($services as $service) {
            Service::create([
                'title' => $service['title'],
                'description' => $service['description'],
                'icon' => $service['icon'],
                'slug' => Str::slug($service['title']['en']),
            ]);
        }

        // 2. Skills
        $skills = [
            ['name' => ['en' => 'PHP/Laravel', 'ar' => 'PHP/Laravel'], 'percentage' => 95],
            ['name' => ['en' => '.NET / .NET Core', 'ar' => '.NET / .NET Core'], 'percentage' => 90],
            ['name' => ['en' => 'React / Angular', 'ar' => 'React / Angular'], 'percentage' => 85],
            ['name' => ['en' => 'MySQL / MSSQL', 'ar' => 'MySQL / MSSQL'], 'percentage' => 95],
            ['name' => ['en' => 'Agile/Scrum', 'ar' => 'Agile/Scrum'], 'percentage' => 90],
            ['name' => ['en' => 'Digital Marketing', 'ar' => 'التسويق الرقمي'], 'percentage' => 80],
            ['name' => ['en' => 'SEO', 'ar' => 'تحسين محركات البحث'], 'percentage' => 75],
        ];

        foreach ($skills as $skill) {
            Skill::create($skill);
        }

        // 3. Experience
        $experiences = [
            [
                'position' => ['en' => 'Technical Lead', 'ar' => 'قائد تقني'],
                'company' => ['en' => 'Smartboxuae.ae', 'ar' => 'Smartboxuae.ae'],
                'location' => ['en' => 'Dubai, UAE', 'ar' => 'دبي، الإمارات'],
                'period' => ['en' => 'Feb 2020 - Present', 'ar' => 'فبراير 2020 - حتى الآن'],
                'description' => ['en' => 'Leading end-to-end development, translating business requirements into technical tasks, ensuring product-market fit.', 'ar' => 'قيادة التطوير من البداية للنهاية، ترجمة متطلبات العمل لمهام تقنية، ضمان ملاءمة المنتج للسوق.'],
                'order' => 1
            ],
            [
                'position' => ['en' => 'Technical Lead', 'ar' => 'قائد تقني'],
                'company' => ['en' => 'Edge-SC', 'ar' => 'Edge-SC'],
                'location' => ['en' => 'Remote', 'ar' => 'عن بعد'],
                'period' => ['en' => '2020 - 2022', 'ar' => '2020 - 2022'],
                'description' => ['en' => 'Architected software solutions focused on measurable business value and ROI.', 'ar' => 'تصميم حلول برمجية تركز على قيمة الأعمال القابلة للقياس وعائد الاستثمار.'],
                'order' => 2
            ],
            [
                'position' => ['en' => 'Technical Lead', 'ar' => 'قائد تقني'],
                'company' => ['en' => 'Manara Al-Safya (Municipality)', 'ar' => 'منارة الصفوة (بلدية حكومية)'],
                'location' => ['en' => 'KSA', 'ar' => 'السعودية'],
                'period' => ['en' => 'Jan 2013 - Jan 2017', 'ar' => 'يناير 2013 - يناير 2017'],
                'description' => ['en' => 'Managed new modules and modifications, drafted analytical reports using market-research techniques.', 'ar' => 'إدارة الوحدات الجديدة والتعديلات، إعداد تقارير تحليلية باستخدام تقنيات أبحاث السوق.'],
                'order' => 3
            ],
        ];

        foreach ($experiences as $exp) {
            Experience::create($exp);
        }

        // 4. Sectors
        $sectors = [
            ['name' => ['en' => 'Government', 'ar' => 'القطاع الحكومي'], 'icon' => 'fa-light fa-landmark'],
            ['name' => ['en' => 'Education', 'ar' => 'التعليم'], 'icon' => 'fa-light fa-graduation-cap'],
            ['name' => ['en' => 'Healthcare', 'ar' => 'الرعاية الصحية'], 'icon' => 'fa-light fa-hospital'],
            ['name' => ['en' => 'Logistics', 'ar' => 'اللوجستيات'], 'icon' => 'fa-light fa-truck'],
            ['name' => ['en' => 'E-commerce', 'ar' => 'التجارة الإلكترونية'], 'icon' => 'fa-light fa-shopping-cart'],
        ];

        foreach ($sectors as $sector) {
            Sector::create([
                'name' => $sector['name'],
                'icon' => $sector['icon'],
                'slug' => Str::slug($sector['name']['en']),
            ]);
        }

        // 5. Projects
        $projects = [
            [
                'title' => ['en' => 'ERP Smart Click', 'ar' => 'ERP Smart Click'],
                'description' => ['en' => 'Comprehensive ERP system covering accounts, payroll, sales, warehouse, HR, attendance, and inventory.', 'ar' => 'نظام ERP متكامل يشمل المحاسبة، الرواتب، المبيعات، المخازن، الموارد البشرية، الحضور، والمخزون.'],
                'project_url' => 'https://vitasignfs.com/',
                'featured_image' => 'assets/images/screencapture-vitasignfs-2026-02-25-17_23_48.png',
                'is_featured' => true
            ],
            [
                'title' => ['en' => 'Tareeb Municipality Systems', 'ar' => 'أنظمة بلدية طريب'],
                'description' => ['en' => 'Governmental ERP modules for lands, health, finance, planning, and more.', 'ar' => 'أنظمة حكومية تشمل الأراضي، الصحة، المالية، التخطيط، والعديد من الوحدات الأخرى.'],
                'project_url' => 'https://xpilotae.cloud/',
                'featured_image' => 'assets/images/screencapture-xpilotae-cloud-2026-02-25-17_29_52.png',
                'is_featured' => true
            ],
            [
                'title' => ['en' => 'UR Freight', 'ar' => 'يور فريت'],
                'description' => ['en' => 'Logistics and freight management platform.', 'ar' => 'منصة إدارة اللوجستيات والشحن.'],
                'project_url' => 'https://ur-freight.com/',
                'featured_image' => 'assets/images/screencapture-ur-freight-2026-02-25-17_26_40.png',
                'is_featured' => true
            ],
            [
                'title' => ['en' => 'Dr. Fawzia Al Jeziri', 'ar' => 'د. فوزية الجزيري'],
                'description' => ['en' => 'Medical and healthcare appointment system.', 'ar' => 'نظام حجز المواعيد الطبية والرعاية الصحية.'],
                'project_url' => 'https://dr-fawziaaljeziri.com/',
                'featured_image' => 'assets/images/screencapture-dr-fawziaaljeziri-2026-02-25-17_27_45.png',
                'is_featured' => true
            ],
        ];

        foreach ($projects as $project) {
            Project::create([
                'title' => $project['title'],
                'description' => $project['description'],
                'project_url' => $project['project_url'],
                'featured_image' => $project['featured_image'],
                'is_featured' => $project['is_featured'],
                'slug' => Str::slug($project['title']['en']),
            ]);
        }
    }
}
