@extends('layouts.admin')

@section('title', 'Edit Blog Post')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-md-3">
            @include('admin.partials.sidebar')
        </div>
        <div class="col-md-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <span>Edit Blog Post: {{ $blog->getTranslation('title', app()->getLocale()) }}</span>
                    <a href="{{ route('admin.blogs.index') }}" class="btn btn-sm btn-secondary">Back</a>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.blogs.update', $blog) }}" method="POST" enctype="multipart/form-data">
                        @csrf @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Title (English)</label>
                                <input type="text" name="title[en]" class="form-control" value="{{ $blog->getTranslation('title', 'en') }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Title (Arabic)</label>
                                <input type="text" name="title[ar]" class="form-control" dir="rtl" value="{{ $blog->getTranslation('title', 'ar') }}" required>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Content (English)</label>
                            <textarea name="content[en]" class="form-control" rows="10" required>{{ $blog->getTranslation('content', 'en') }}</textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Content (Arabic)</label>
                            <textarea name="content[ar]" class="form-control" rows="10" dir="rtl" required>{{ $blog->getTranslation('content', 'ar') }}</textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Featured Image</label>
                            @if($blog->featured_image)
                                <div class="mb-2">
                                    <img src="{{ asset('storage/' . $blog->featured_image) }}" width="100" alt="Current Image">
                                </div>
                            @endif
                            <input type="file" name="featured_image" class="form-control">
                        </div>

                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" name="is_active" value="1" id="is_active" {{ $blog->is_active ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">Active</label>
                        </div>

                        <button type="submit" class="btn btn-primary">Update Blog Post</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
