@extends('layouts.admin')

@section('title', 'Blog Management')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-md-3">
            @include('admin.partials.sidebar')
        </div>
        <div class="col-md-9">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2>Blogs</h2>
                <a href="{{ route('admin.blogs.create') }}" class="btn btn-primary">Add New Post</a>
            </div>
            
            <table class="table table-bordered bg-white">
                <thead>
                    <tr>
                        <th>Title (EN)</th>
                        <th>Title (AR)</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($blogs as $blog)
                        <tr>
                            <td>{{ $blog->getTranslation('title', 'en') }}</td>
                            <td>{{ $blog->getTranslation('title', 'ar') }}</td>
                            <td>{{ $blog->is_active ? 'Active' : 'Draft' }}</td>
                            <td>
                                <a href="{{ route('admin.blogs.edit', $blog) }}" class="btn btn-sm btn-info">Edit</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">No blog posts found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
