@extends('layouts.admin')

@section('title', 'Edit Project')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-md-3">
            @include('admin.partials.sidebar')
        </div>
        <div class="col-md-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <span>Edit Project: {{ $project->getTranslation('title', app()->getLocale()) }}</span>
                    <a href="{{ route('admin.projects.index') }}" class="btn btn-sm btn-secondary">Back</a>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form action="{{ route('admin.projects.update', $project) }}" method="POST" enctype="multipart/form-data">
                        @csrf @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Title (English)</label>
                                <input type="text" name="title[en]" class="form-control" value="{{ $project->getTranslation('title', 'en') }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Title (Arabic)</label>
                                <input type="text" name="title[ar]" class="form-control" dir="rtl" value="{{ $project->getTranslation('title', 'ar') }}" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Client (English)</label>
                                <input type="text" name="client[en]" class="form-control" value="{{ $project->getTranslation('client', 'en') }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Client (Arabic)</label>
                                <input type="text" name="client[ar]" class="form-control" dir="rtl" value="{{ $project->getTranslation('client', 'ar') }}">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description (English)</label>
                            <textarea name="description[en]" class="form-control" rows="4" required>{{ $project->getTranslation('description', 'en') }}</textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description (Arabic)</label>
                            <textarea name="description[ar]" class="form-control" rows="4" dir="rtl" required>{{ $project->getTranslation('description', 'ar') }}</textarea>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Duration</label>
                                <input type="text" name="duration" class="form-control" value="{{ $project->duration }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Project URL</label>
                                <input type="url" name="project_url" class="form-control" value="{{ $project->project_url }}">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Featured Image</label>
                            @if($project->featured_image)
                                <div class="mb-2">
                                    @php
                                        $previewPath = $project->featured_image;
                                        if (!Str::startsWith($previewPath, 'assets/')) {
                                            $previewPath = 'storage/' . $previewPath;
                                        }
                                    @endphp
                                    <img src="{{ asset($previewPath) }}" width="100" alt="Current Image">
                                </div>
                            @endif
                            <input type="file" name="featured_image" class="form-control">
                        </div>

                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" name="is_featured" value="1" id="is_featured" {{ $project->is_featured ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_featured">Featured Project</label>
                        </div>

                        <button type="submit" class="btn btn-primary">Update Project</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
