@extends('layouts.admin')

@section('title', 'Project Management')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-md-3">
            @include('admin.partials.sidebar')
        </div>
        <div class="col-md-9">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2>Projects</h2>
                <a href="{{ route('admin.projects.create') }}" class="btn btn-primary">Add New Project</a>
            </div>
            
            <table class="table table-bordered bg-white">
                <thead>
                    <tr>
                        <th>Title (EN)</th>
                        <th>Title (AR)</th>
                        <th>Category</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($projects as $project)
                        <tr>
                            <td>{{ $project->getTranslation('title', 'en') }}</td>
                            <td>{{ $project->getTranslation('title', 'ar') }}</td>
                            <td>{{ $project->category?->name ?? 'N/A' }}</td>
                            <td>
                                <a href="{{ route('admin.projects.edit', $project) }}" class="btn btn-sm btn-info">Edit</a>
                                <form action="{{ route('admin.projects.destroy', $project) }}" method="POST" class="d-inline">
                                    @csrf @method('DELETE')
                                    <button class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">No projects found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
