@extends('layouts.admin')

@section('title', 'Service Management')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-md-3">
            @include('admin.partials.sidebar')
        </div>
        <div class="col-md-9">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2>Services</h2>
                <a href="{{ route('admin.services.create') }}" class="btn btn-primary">Add New Service</a>
            </div>
            
            <table class="table table-bordered bg-white">
                <thead>
                    <tr>
                        <th>Title (EN)</th>
                        <th>Title (AR)</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($services as $service)
                        <tr>
                            <td>{{ $service->getTranslation('title', 'en') }}</td>
                            <td>{{ $service->getTranslation('title', 'ar') }}</td>
                            <td>
                                <a href="{{ route('admin.services.edit', $service) }}" class="btn btn-sm btn-info">Edit</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" class="text-center">No services found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
