@extends('layouts.admin')

@section('title', 'Create Skill')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-md-3">
            @include('admin.partials.sidebar')
        </div>
        <div class="col-md-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <span>Create New Skill</span>
                    <a href="{{ route('admin.skills.index') }}" class="btn btn-sm btn-secondary">Back</a>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.skills.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Name (English)</label>
                                <input type="text" name="name[en]" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Name (Arabic)</label>
                                <input type="text" name="name[ar]" class="form-control" dir="rtl" required>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Percentage (0-100)</label>
                            <input type="number" name="percentage" class="form-control" min="0" max="100" required>
                        </div>

                        <button type="submit" class="btn btn-primary">Save Skill</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
