@extends('layouts.admin')

@section('title', 'Skill Management')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-md-3">
            @include('admin.partials.sidebar')
        </div>
        <div class="col-md-9">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2>Skills</h2>
                <a href="{{ route('admin.skills.create') }}" class="btn btn-primary">Add New Skill</a>
            </div>
            
            <table class="table table-bordered bg-white">
                <thead>
                    <tr>
                        <th>Name (EN)</th>
                        <th>Name (AR)</th>
                        <th>Percentage</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($skills as $skill)
                        <tr>
                            <td>{{ $skill->getTranslation('name', 'en') }}</td>
                            <td>{{ $skill->getTranslation('name', 'ar') }}</td>
                            <td>{{ $skill->percentage }}%</td>
                            <td>
                                <a href="{{ route('admin.skills.edit', $skill) }}" class="btn btn-sm btn-info">Edit</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">No skills found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
