@extends('layouts.app')

@section('title', __('messages.site_title'))

@section('content')

    <!-- Preloader -->
    {{-- <div class="preloader"></div> --}}

    <!-- tpm-header-area start -->
    <header class="tmp-header-area-start header-one header--sticky header--transparent">
        <div class="container-fluid" style="padding-left: 5%; padding-right: 5%;">
            <div class="row">
                <div class="col-lg-12">
                    <div class="header-content">
                        <div class="logo">
                            <a href="{{ url('/') }}">
                                <img class="logo-dark" src="{{ asset('assets/images/logo.png') }}" alt="Logo">
                                <img class="logo-white" src="{{ asset('assets/images/logo.png') }}" alt="Logo">
                            </a>
                        </div>
                        <nav class="tmp-mainmenu-nav d-none d-xl-block">
                            <ul class="tmp-mainmenu">
                                <li><a href="#">{{ __('messages.nav_home') }}</a></li>
                                <li><a href="#about">{{ __('messages.nav_about') }}</a></li>
                                <li><a href="#sectors">{{ __('messages.nav_sectors') }}</a></li>
                                <li><a href="#experience">{{ __('messages.nav_experience') }}</a></li>
                                <li><a href="#portfolio">{{ __('messages.nav_portfolio') }}</a></li>
                                <li><a href="#blog">{{ __('messages.nav_blog') }}</a></li>
                                <li><a href="#contact">{{ __('messages.nav_contact') }}</a></li>
                                
                                <li class="has-dropdown">
                                    <a href="#">{{ app()->getLocale() == 'ar' ? 'العربية' : 'English' }} <i class="fa-regular fa-globe"></i></a>
                                    <ul class="submenu">
                                        <li><a href="{{ url('lang/en') }}">English</a></li>
                                        <li><a href="{{ url('lang/ar') }}">العربية</a></li>
                                    </ul>
                                </li>

                                {{-- Laravel Auth Links --}}
                                @if (Route::has('login'))
                                    @auth
                                        <li><a href="{{ url('/dashboard') }}" class="theme-gradient">Dashboard</a></li>
                                    @else
                                        <li><a href="{{ route('login') }}">Log in</a></li>
                                    @endauth
                                @endif
                            </ul>
                        </nav>
                        <div class="tmp-header-right">
                            <div class="social-share-wrapper d-none d-md-block">
                                <div class="social-link">
                                    <a href="https://www.instagram.com/besho_online"><i class="fa-brands fa-instagram"></i></a>
                                    <a href="https://www.linkedin.com/in/bishoy-khalil/"><i class="fa-brands fa-linkedin-in"></i></a>
                                    {{-- <a href="#"><i class="fa-brands fa-twitter"></i></a> --}}
                                    <a href="https://www.facebook.com/besho.george.9/"><i class="fa-brands fa-facebook-f"></i></a>
                                </div>
                            </div>
                            <div class="actions-area">
                                <div class="tmp-side-collups-area">
                                    <button class="tmp-menu-bars humberger_menu_active tmp_button_active"><i class="fa-regular fa-bars-staggered"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- tpm-header-area end -->

    <div class="d-none d-xl-block">
        <div class="tmp-sidebar-area tmp_side_bar">
            <div class="inner">
                <div class="top-area">
                    <a href="{{ url('/') }}" class="logo">
                        <img class="logo-dark" src="{{ asset('assets/images/logo.png') }}" alt="Logo">
                        <img class="logo-white" src="{{ asset('assets/images/logo.png') }}" alt="Logo">
                    </a>
                    <div class="close-icon-area">
                        <button class="tmp-round-action-btn close_side_menu_active">
                            <i class="fa-sharp fa-light fa-xmark"></i>
                        </button>
                    </div>
                </div>
                <div class="content-wrapper">
                    <div class="image-area-feature">
                        <a href="{{ url('/') }}">
                            <img src="{{ asset('assets/images/banner/besho.png') }}" alt="personal-logo">
                        </a>
                    </div>
                    <h5 class="title mt--30">{{ __('messages.role') }}</h5>
                    <p class="disc">{{ __('messages.about_description') }}</p>
                    <div class="button-area-banner-one mt--30">
                        <a class="tmp-btn hover-icon-reverse radius-round" href="{{ asset('assets/' . __('messages.cv_file')) }}" download>
                            <span class="icon-reverse-wrapper">
                                <span class="btn-text">{{ __('messages.download_cv') }}</span>
                                <span class="btn-icon"><i class="fa-sharp fa-regular fa-download"></i></span>
                            </span>
                        </a>
                    </div>
                    <div class="short-contact-area">
                        <div class="single-contact">
                            <i class="fa-solid fa-phone"></i>
                            <div class="information tmp-link-animation">
                                <span>Call Now</span>
                                <a href="#" class="number">+971545060739</a>
                            </div>
                        </div>
                        <div class="single-contact">
                            <i class="fa-solid fa-envelope"></i>
                            <div class="information tmp-link-animation">
                                <span>Mail Us</span>
                                <a href="#" class="number">info@sehasave.com</a>
                            </div>
                        </div>
                    </div>
                    <div class="social-wrapper mt--20">
                        <span class="subtitle">find with me</span>
                        <div class="social-link">
                            <a href="https://www.instagram.com/besho_online"><i class="fa-brands fa-instagram"></i></a>
                            <a href="https://www.linkedin.com/in/bishoy-khalil/"><i class="fa-brands fa-linkedin-in"></i></a>
                            {{-- <a href="#"><i class="fa-brands fa-twitter"></i></a> --}}
                            <a href="https://www.facebook.com/besho.george.9/"><i class="fa-brands fa-facebook-f"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <a class="overlay_close_side_menu close_side_menu_active" href="javascript:void(0);"></a>
    </div>

    <div class="d-block d-xl-none">
        <div class="tmp-popup-mobile-menu">
            <div class="inner">
                <div class="header-top">
                    <div class="logo">
                        <a href="{{ url('/') }}" class="logo-area">
                            <img class="logo-dark" src="{{ asset('assets/images/logo/white-logo-reeni.png') }}" alt="Logo">
                            <img class="logo-white" src="{{ asset('assets/images/logo/logo-white.png') }}" alt="Logo">
                        </a>
                    </div>
                    <div class="close-menu">
                        <button class="close-button tmp-round-action-btn">
                            <i class="fa-sharp fa-light fa-xmark"></i>
                        </button>
                    </div>
                </div>
                <ul class="tmp-mainmenu">
                    <li><a href="#">{{ __('messages.nav_home') }}</a></li>
                    <li><a href="#about">{{ __('messages.nav_about') }}</a></li>
                    <li><a href="#contact">{{ __('messages.nav_contact') }}</a></li>
                    <li><a href="{{ url('lang/en') }}">English</a></li>
                    <li><a href="{{ url('lang/ar') }}">العربية</a></li>
                </ul>
                <div class="social-wrapper mt--40">
                    <span class="subtitle">find with me</span>
                    <div class="social-link">
                        <a href="https://www.instagram.com/besho_online"><i class="fa-brands fa-instagram"></i></a>
                        <a href="https://www.linkedin.com/in/bishoy-khalil/"><i class="fa-brands fa-linkedin-in"></i></a>
                        {{-- <a href="#"><i class="fa-brands fa-twitter"></i></a> --}}
                        <a href="https://www.facebook.com/besho.george.9/"><i class="fa-brands fa-facebook-f"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- tmp banner area start -->
    <div class="tmp-banner-one-area" id="home">
        <div class="container">
            <div class="banner-one-main-wrapper">
                <div class="row align-items-center">
                    <div class="col-lg-6 order-lg-2">
                        <div class="banner-right-content">
                            <img class="tmp-scroll-trigger tmp-zoom-in animation-order-1" src="{{ asset('assets/images/banner/besho.png') }}" alt="banner-img">
                            {{-- <h2 class="banner-big-text-1 up-down">{{ __('messages.hero_title_2') }}</h2> --}}
                            <h2 class="banner-big-text-2 up-down-2">{{ __('messages.hero_title_3') }}</h2>
                        </div>
                    </div>
                    <div class="col-lg-6 order-lg-1">
                        <div class="inner">
                            <span class="sub-title tmp-scroll-trigger text-reveal tmp-fade-in animation-order-1">{{ __('messages.hero_subtitle') }}</span>
                            <h1 class="title tmp-scroll-trigger tmp-fade-in animation-order-2 mt--5">{{ __('messages.hero_title_1') }}<br>
                                <span class="header-caption">
                                    <span class="cd-headline clip is-full-width">
                                        <span class="cd-words-wrapper">
                                            <b class="is-visible theme-gradient">{{ __('messages.hero_title_2') }}</b>
                                            <b class="is-hidden theme-gradient">{{ __('messages.hero_title_3') }}</b>
                                            <b class="is-hidden theme-gradient">{{ __('messages.hero_title_4') }}</b>
                                        </span>
                                    </span>
                                </span>
                            </h1>
                            <p class="disc tmp-scroll-trigger tmp-fade-in animation-order-3">{{ __('messages.hero_description') }}</p>
                            <div class="button-area-banner-one tmp-scroll-trigger tmp-fade-in animation-order-4">
                                <a class="tmp-btn hover-icon-reverse radius-round" href="#">
                                    <span class="icon-reverse-wrapper">
                                        <span class="btn-text">{{ __('messages.hero_btn_portfolio') }}</span>
                                        <span class="btn-icon"><i class="fa-sharp fa-regular fa-arrow-right"></i></span>
                                        <span class="btn-icon"><i class="fa-sharp fa-regular fa-arrow-right"></i></span>
                                    </span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- tmp banner area end -->

    <!-- About Section -->
    <section class="about-area tmp-section-gapTop" id="about">
        <div class="container">
            <div class="row align-items-center g-5">
                <div class="col-lg-6">
                    <div class="about-thumbnails tmp-scroll-trigger tmp-fade-in">
                        <img src="{{ asset('assets/images/logo.png') }}" alt="About Me">
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="about-content">
                        <div class="section-head text-align-left mb--30">
                            <div class="section-sub-title tmp-scroll-trigger tmp-fade-in">
                                <span class="subtitle">{{ __('messages.nav_about') }}</span>
                            </div>
                            <h2 class="title split-collab tmp-scroll-trigger tmp-fade-in">{{ __('messages.about_title') }}</h2>
                        </div>
                        <p class="disc tmp-scroll-trigger tmp-fade-in animation-order-2">
                            {{ __('messages.about_description') }}
                        </p>
                        <div class="button-area-about mt--40 tmp-scroll-trigger tmp-fade-in animation-order-3">
                            <a class="tmp-btn hover-icon-reverse radius-round" href="{{ asset('assets/' . __('messages.cv_file')) }}" download>
                                <span class="icon-reverse-wrapper">
                                    <span class="btn-text">{{ __('messages.download_cv') }}</span>
                                    <span class="btn-icon"><i class="fa-sharp fa-regular fa-download"></i></span>
                                </span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="education-area tmp-section-gapTop" id="education">
        <div class="container">
            <div class="row g-5">
                <div class="col-lg-6">
                    <div class="section-head text-align-left mb--30">
                        <div class="section-sub-title tmp-scroll-trigger tmp-fade-in">
                            <span class="subtitle">Education</span>
                        </div>
                        <h2 class="title split-collab tmp-scroll-trigger tmp-fade-in">Academic Background</h2>
                    </div>
                    <div class="experience-card p-4 mb-4 bg-blur-style-one tmp-scroll-trigger tmp-fade-in">
                        <h4 class="title mb-1">Bachelor of Science in Computer Information Systems</h4>
                        <p class="theme-gradient">University Degree</p>
                    </div>
                    <div class="experience-card p-4 bg-blur-style-one tmp-scroll-trigger tmp-fade-in">
                        <h4 class="title mb-1">Mini Master in Business Administration and Leading Business</h4>
                        <p class="theme-gradient">Professional Certification</p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="section-head text-align-left mb--30">
                        <div class="section-sub-title tmp-scroll-trigger tmp-fade-in">
                            <span class="subtitle">Languages</span>
                        </div>
                        <h2 class="title split-collab tmp-scroll-trigger tmp-fade-in">Fluent In</h2>
                    </div>
                    <div class="row g-4">
                        <div class="col-6">
                            <div class="counter-card text-center tmponhover tmp-scroll-trigger tmp-fade-in">
                                <h3 class="counter">Arabic</h3>
                                <p class="counter-para">Native</p>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="counter-card text-center tmponhover tmp-scroll-trigger tmp-fade-in">
                                <h3 class="counter">English</h3>
                                <p class="counter-para">Professional</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Tpm Service Area Start -->
    <section class="service-area tmp-section-gap" id="services">
        <div class="container">
            <div class="section-head mb--60">
                <div class="section-sub-title center-title tmp-scroll-trigger tmp-fade-in">
                    <span class="subtitle">{{ __('messages.services_subtitle') }}</span>
                </div>
                <h2 class="title split-collab tmp-scroll-trigger tmp-fade-in">{{ __('messages.services_title') }}</h2>
            </div>
            <div class="row justify-content-center g-5">
                @foreach($services as $service)
                <div class="col-lg-4 col-md-6 col-sm-12">
                    <div class="service-card-v1 tmp-scroll-trigger tmp-fade-in animation-order-{{ $loop->iteration }} tmp-link-animation h-100">
                        <div class="service-card-icon"><i class="{{ $service->icon }}"></i></div>
                        <h4 class="service-title"><a href="#">{{ $service->getTranslation('title', app()->getLocale()) }}</a></h4>
                        <p class="service-para">{{ $service->getTranslation('description', app()->getLocale()) }}</p>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>

    <!-- Tpm Counter Area Start -->
    <section class="counter-area">
        <div class="container">
            <div class="row g-5">
                <div class="col-12 col-lg-6 col-xl-6">
                    <div class="year-of-expariance-wrapper bg-blur-style-one tmp-scroll-trigger tmp-fade-in animation-order-1">
                        <div class="year-expariance-wrap">
                            <h2 class="counter year-number"><span class="odometer" data-count="14">00</span></h2>
                            <h3 class="year-title">{{ __('messages.about_experience_years') }}</h3>
                        </div>
                        <p class="year-para">{{ __('messages.role') }}</p>
                    </div>
                </div>
                <div class="col-12 col-lg-6 col-xl-6">
                    <div class="counter-area-right-content">
                        <div class="row g-5">
                            <div class="col-lg-6 col-sm-6">
                                <div class="counter-card tmponhover tmp-scroll-trigger tmp-fade-in animation-order-1">
                                    <h3 class="counter"><span class="odometer" data-count="50">00</span>+</h3>
                                    <p class="counter-para">{{ __('messages.about_projects_completed') }}</p>
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-6">
                                <div class="counter-card tmponhover tmp-scroll-trigger tmp-fade-in animation-order-2">
                                    <h3 class="counter"><span class="odometer" data-count="100">00</span>+</h3>
                                    <p class="counter-para">{{ __('messages.about_clients_worldwide') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Sectors Section -->
    <section class="sectors-area tmp-section-gapTop" id="sectors">
        <div class="container">
            <div class="section-head mb--60">
                <div class="section-sub-title center-title tmp-scroll-trigger tmp-fade-in">
                    <span class="subtitle">{{ __('messages.nav_sectors') }}</span>
                </div>
                <h2 class="title split-collab tmp-scroll-trigger tmp-fade-in">{{ __('messages.sectors_subtitle') }}</h2>
            </div>
            <div class="row g-5">
                @foreach($sectors as $sector)
                <div class="col-lg-4 col-md-6 col-sm-12">
                    <div class="service-card-v1 tmponhover tmp-scroll-trigger tmp-fade-in animation-order-{{ $loop->iteration }} h-100">
                        <div class="service-card-icon"><i class="{{ $sector->icon }}"></i></div>
                        <h4 class="service-title">{{ $sector->getTranslation('name', app()->getLocale()) }}</h4>
                        <p class="service-para">{{ $sector->getTranslation('description', app()->getLocale()) }}</p>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>

    <!-- Experience Section -->
    <section class="experience-area tmp-section-gapTop" id="experience">
        <div class="container">
            <div class="section-head mb--60">
                <div class="section-sub-title center-title tmp-scroll-trigger tmp-fade-in">
                    <span class="subtitle">{{ __('messages.nav_experience') }}</span>
                </div>
                <h2 class="title split-collab tmp-scroll-trigger tmp-fade-in">{{ __('messages.experience_subtitle') }}</h2>
            </div>
            <div class="row g-5">
                @foreach($experiences as $exp)
                <div class="col-12">
                    <div class="experience-card p-5 bg-blur-style-one tmp-scroll-trigger tmp-fade-in">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <div>
                                <h3 class="title mb-0">{{ $exp->getTranslation('position', app()->getLocale()) }}</h3>
                                <span class="theme-gradient">{{ $exp->getTranslation('company', app()->getLocale()) }}</span>
                            </div>
                            <div class="text-end">
                                <span class="badge bg-primary">{{ $exp->getTranslation('period', app()->getLocale()) }}</span>
                                <p class="mb-0 mt-2"><i class="fa-light fa-location-dot me-2"></i>{{ $exp->getTranslation('location', app()->getLocale()) }}</p>
                            </div>
                        </div>
                        <p class="disc">{{ $exp->getTranslation('description', app()->getLocale()) }}</p>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>

    <!-- Portfolio Section -->
    <div class="latest-portfolio-area tmp-section-gapTop" id="portfolio">
        <div class="container">
            <div class="section-head mb--60">
                <div class="section-sub-title center-title tmp-scroll-trigger tmp-fade-in">
                    <span class="subtitle">{{ __('messages.portfolio_subtitle') }}</span>
                </div>
                <h2 class="title split-collab tmp-scroll-trigger tmp-fade-in">{{ __('messages.portfolio_title') }}</h2>
            </div>
            <div class="row g-5">
                @foreach($projects as $project)
                <div class="col-lg-6 col-sm-6">
                    <div class="latest-portfolio-card tmp-hover-link tmp-scroll-trigger tmp-fade-in">
                        <div class="portfoli-card-img">
                            <a href="{{ $project->project_url ?? '#' }}">
                                @php
                                    $imagePath = $project->featured_image;
                                    if ($imagePath && !Str::startsWith($imagePath, 'assets/')) {
                                        $imagePath = 'storage/' . $imagePath;
                                    }
                                    $finalImage = $imagePath ? asset($imagePath) : asset('assets/images/latest-portfolio/portfoli-img-1.jpg');
                                @endphp
                                <img class="w-100" src="{{ $finalImage }}" alt="Portfolio">
                            </a>
                        </div>
                        <div class="portfolio-card-content-wrap">
                            <h3 class="portfolio-card-title"><a href="{{ $project->project_url ?? '#' }}">{{ $project->getTranslation('title', app()->getLocale()) }}</a></h3>
                            <p class="portfoli-card-para">{{ $project->getTranslation('description', app()->getLocale()) }}</p>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Contact Section -->
    <section id="contact" class="get-in-touch-area tmp-section-gap">
        <div class="container">
            <div class="contact-get-in-touch-wrap">
                <div class="get-in-touch-wrapper tmponhover">
                    <div class="row g-5 align-items-center">
                        <div class="col-lg-5">
                            <div class="section-head text-align-left">
                                <div class="section-sub-title tmp-scroll-trigger tmp-fade-in">
                                    <span class="subtitle">{{ __('messages.contact_subtitle') }}</span>
                                </div>
                                <h2 class="title split-collab tmp-scroll-trigger tmp-fade-in">{{ __('messages.contact_title') }}</h2>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="contact-inner">
                                @if(session('success'))
                                    <div class="alert alert-success mt-3 mb-3">
                                        {{ session('success') }}
                                    </div>
                                @endif

                                @if($errors->any())
                                    <div class="alert alert-danger mt-3 mb-3">
                                        <ul>
                                            @foreach($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                <form class="tmp-dynamic-form" id="contact-form" method="POST" action="{{ route('contact.store') }}">
                                    @csrf
                                    <div class="contact-form-wrapper row">
                                        <div class="col-lg-6">
                                            <input class="input-field" name="name" placeholder="{{ __('messages.contact_name') }}" type="text" required>
                                        </div>
                                        <div class="col-lg-6">
                                            <input class="input-field" name="email" placeholder="{{ __('messages.contact_email') }}" type="email" required>
                                        </div>
                                        <div class="col-lg-12">
                                            <textarea class="input-field" placeholder="{{ __('messages.contact_message') }}" name="message" required></textarea>
                                        </div>
                                        <div class="col-lg-12">
                                            <button class="tmp-btn hover-icon-reverse radius-round w-100" type="submit">
                                                <span class="icon-reverse-wrapper">
                                                    <span class="btn-text">{{ __('messages.contact_send') }}</span>
                                                    <span class="btn-icon"><i class="fa-sharp fa-regular fa-arrow-right"></i></span>
                                                </span>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer-area footer-style-one-wrapper bg-color-footer tmp-section-gap">
        <div class="container">
            <div class="footer-main footer-style-one text-center">
                <div class="logo">
                    <a href="{{ url('/') }}">
                        <img src="{{ asset('assets/images/logo.png') }}" alt="Logo">
                    </a>
                </div>
                <p class="description mt--20">© {{ date('Y') }} {{ __('messages.name') }}. {{ __('messages.all_rights_reserved') }}</p>
                <div class="social-link footer mt--20">
                    <a href="https://www.instagram.com/besho_online"><i class="fa-brands fa-instagram"></i></a>
                    <a href="https://www.linkedin.com/in/bishoy-khalil/"><i class="fa-brands fa-linkedin-in"></i></a>
                    {{-- <a href="#"><i class="fa-brands fa-twitter"></i></a> --}}
                    <a href="https://www.facebook.com/besho.george.9/"><i class="fa-brands fa-facebook-f"></i></a>
                </div>
            </div>
        </div>
    </footer>

    <div class="scrollToTop">
        <div class="arrowUp"><i class="fa-light fa-arrow-up"></i></div>
    </div>

    <!-- WhatsApp Button -->
    <a href="https://wa.me/971545060739" class="whatsapp-float" target="_blank">
        <i class="fa-brands fa-whatsapp my-float"></i>
    </a>

    <style>
        .whatsapp-float {
            position: fixed;
            width: 60px;
            height: 60px;
            bottom: 40px;
            right: 40px;
            background-color: #25d366;
            color: #FFF;
            border-radius: 50px;
            text-align: center;
            font-size: 30px;
            box-shadow: 2px 2px 3px #999;
            z-index: 100;
        }

        .my-float {
            margin-top: 16px;
        }

        [dir="rtl"] .whatsapp-float {
            right: auto;
            left: 40px;
        }
    </style>
    @if(session('success'))
        <script>
            window.onload = function() {
                var element = document.getElementById("contact");
                if (element) {
                    element.scrollIntoView({ behavior: 'smooth' });
                }
            };
        </script>
    @endif
@endsection
